/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2009 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

/**
 * This function is called when the user clicks on the Get Extension button
 */
function getResources() {
	var obj = {
		GetExtensionURL: dw.loadString( 'BusinessCatalyst/GetExtensionURL' ),
		LearnMoreURL: dw.loadString( 'BusinessCatalyst/LearnMoreURL' ),
		GetExtensionTitle: dw.loadString( 'BusinessCatalyst/GetExtensionTitle' ),
		GetExtensionParagraph: dw.loadString( 'BusinessCatalyst/GetExtensionParagraph' ),
		GetExtensionButton: dw.loadString( 'BusinessCatalyst/GetExtensionButton' ),
		GetExtensionNote: dw.loadString( 'BusinessCatalyst/GetExtensionNote' ),
		NewToBCTitle: dw.loadString( 'BusinessCatalyst/NewToBCTitle' ),
		NewToBCParagraph: dw.loadString( 'BusinessCatalyst/NewToBCParagraph' ),
		LearnMoreButton: dw.loadString( 'BusinessCatalyst/LearnMoreButton' )
	};

	return serialize( obj );
};

/**
 * Retrieves the current color palette used by the Dreamweaver application
 *
 * @return String The palette color in RGB 8 bit format, serialized
 */
function getDWBackgroundColor() {
	var panelColor = dw.getPanelColor();
	var red = panelColor[0];
	var green = panelColor[1];
	var blue = panelColor[2];

	var color = ( red << 16 ) + ( green << 8 ) + blue;

	return serialize( color );
};

/**
 * Serializes the given parameter in order to be passed back to Flash control
 */
function serialize( obj ) {
	var retStr = "";

	if ( typeof(obj) == "object" ) {
		for ( var i in obj ) {
			retStr += "<property id=\"" + i + "\">" + serialize( obj[i] ) + "</property>";
		}
		retStr = "<object>" + retStr + "</object>";
	} else {
		var type = "string";
		retStr = "<" + type + ">" + obj + "</" + type + ">";
	}

	return retStr;
};

